# coding: utf-8

from rest_framework.permissions import BasePermission

from procu.api import enums, models


class PublishRequestPermission(BasePermission):
    model_class = models.Enquiry

    def has_permission(self, request, view):

        can_make_progress = request.user.has_perm('api.progress_enquiry')

        if not can_make_progress:
            return False

        enquiry = view.object

        if enquiry.status != enums.ES.DRAFT:
            return False

        has_rfx = models.Request.objects.filter(enquiry_id=enquiry.id).exists()

        if has_rfx:
            return False

        return super().has_permission(request, view)
