# coding: utf-8

from procu.api.enums import QR, QS
from procu.jsonschema import schema as js
from ..fields import QReasonField, QStatusField


class BulkStatusField(QStatusField):
    def get_schema(self, write=False, *args, **kwargs):

        if write:
            keys = list(QS.keys.values())[1:]
            i18ns = list(QS.i18n.values())[1:]
            return js.String(enum=keys, **{'x-names': dict(zip(keys, i18ns))})

        if self.name_only:
            return js.String()

        return js.Object(('key', js.String()), ('name', js.String()))


class BulkReasonField(QReasonField):
    def get_schema(self, write=False, *args, **kwargs):

        if write:
            keys = list(QR.keys.values())
            i18ns = list(QR.i18n.values())
            i18ns[0] = '—'
            return js.String(enum=keys, **{'x-names': dict(zip(keys, i18ns))})

        if self.name_only:
            return js.String()

        return js.Object(('key', js.String()), ('name', js.String()))
