# coding: utf-8
from django.utils.translation import gettext_lazy as _

from procu.rest import serializers
from .fields import BulkReasonField, BulkStatusField


class BulkStatusChange(serializers.Serializer):
    quotes = serializers.ListField(
        label=_('QUOTE_BULK::QUOTES'), child=serializers.IntegerField()
    )
    status = BulkStatusField(label=_('QUOTE_BULK::STATUS'))
    reason = BulkReasonField(
        label=_('QUOTE_BULK::REASON'), allow_null=True, required=False
    )
