# coding: utf-8

from rest_framework.permissions import BasePermission

from procu.api import enums, models


class ListCreateRetrievePermission(BasePermission):
    def has_permission(self, request, view):

        # ----------------------------------------------------------------------

        user = request.user

        def has_access():

            try:
                enquiry_id = models.Request.objects.values_list(
                    'enquiry_id'
                ).get(quotes=view.kwargs['quote_id'])

            except models.Request.DoesNotExist:
                return False

            qs = models.EnquiryAccess.objects.filter(
                user_id=user.id, enquiry_id=enquiry_id
            )

            if not user.has_perm('api.progress_enquiry'):
                qs = qs.filter(
                    sources__contains=[enums.ACCESS_SOURCE.ACCESS],
                    allow_quote_comments=True,
                )

            return qs.exists()

        # ----------------------------------------------------------------------

        if request.method == 'POST':

            # Regardless of the role,
            # one cannot post comments in an unpublished quotes

            is_published = models.Quote.objects.filter(
                id=view.kwargs['quote_id'], status__gt=enums.QS.DRAFT
            ).exists()

            if not is_published:
                return False

            return (
                user.has_perms(['api.all_enquiry', 'api.progress_enquiry'])
                or has_access()
            )

        else:
            return user.has_perm('api.all_enquiry') or has_access()


class UpdateDestroyPermission(BasePermission):
    def has_permission(self, request, view):

        if request.method in ('PATCH', 'DELETE'):
            instance = view.object
            return instance.author_id == request.user.id

        return True
