# coding: utf-8

from procu.api.enums import QS
from procu.api.push.external import notify_quote_shipped, notify_quote_updated
from procu.api.utils import dict_diff


def quote_notify(user, quote_id, transition, old, new):

    fields = ('deadline_at', 'payment_terms', 'status', 'reason')
    diff = dict_diff(old, new, fields=fields, show_unchanged=False)

    if transition == (QS.CLOSED, QS.CLOSED) or transition[0] == QS.DRAFT:
        return []

    elif transition[0] != transition[1] and transition[1] == QS.SHIPPED:
        return notify_quote_shipped(quote_id, user)

    elif any(f in diff for f in ('status', 'deadline_at', 'products')):
        return notify_quote_updated(quote_id, user, diff)

    return []
