# coding: utf-8

from procu.api.enums import QS
from procu.rest.permissions import EntryPermission, ListPermission


class ListCreate(ListPermission):
    default_perms_map = {
        'GET': ['%(app_label)s.list_quote'],
        'POST': ['%(app_label)s.create_quote'],
    }


class RetrieveUpdateDestroy(EntryPermission):
    def has_object_permission(self, request, view, obj):
        if request.method == 'DELETE' and obj.status != QS.DRAFT:
            return False
        return super().has_object_permission(request, view, obj)
