# coding: utf-8

from rest_framework.permissions import BasePermission

from procu.api import enums, models


class ReplaceProductsPermission(BasePermission):
    def has_permission(self, request, view):

        if not request.user.has_perm('api.progress_enquiry'):
            return False

        qs = models.Quote.objects.permitted(request.user).filter(
            id=view.kwargs['quote_id'], status__gt=enums.QS.DRAFT
        )

        return qs.exists()
