# coding: utf-8

from procu.api import models
from procu.rest import serializers
from procu.rest.fields import MonetaryField


class QuoteProduct(serializers.ModelSerializer):
    id = serializers.IntegerField(required=False)

    enquiry_product = serializers.IntegerField(source='enquiry_product_id')
    currency = serializers.IntegerField(source='currency_id')

    price = MonetaryField(allow_null=True, required=False)
    tax = MonetaryField(normalize=True)

    class Meta:
        model = models.QuoteProduct
        fields = (
            'id',
            # ----------------
            'name',
            'qty',
            'price',
            'comment',
            'delivery_time',
            # ----------------
            'enquiry_product',
            'currency',
            'tax',
            'is_tax_included',
            'is_replacement',
            'is_per_unit',
        )
