# coding: utf-8

from django.urls import include, path, re_path

from .views import *


def _include(path):
    return include('procu.api.enquiry.quote.%s' % path)


urlpatterns = [
    path(
        '/<int:quote_id>',
        include(
            [
                # New
                re_path(r'^/comments', _include('comment.urls')),
                # Old
                re_path(r'^/scs', _include('scs.urls')),
                re_path(r'^/warehouse', _include('warehouse.urls')),
                re_path(r'^/offer', _include('summary.urls')),
                re_path(r'^/products', _include('products.urls')),
                re_path(r'^/status$', QuoteStatusUpdate.as_view()),
                re_path(r'^/?$', QuoteRetrieveUpdateDestroy.as_view()),
            ]
        ),
    ),
    re_path(r'^/bulk', _include('bulk.urls')),
    re_path(r'^/by_status/?$', QuoteGroupedList.as_view()),
    re_path(r'^/?$', QuoteCreate.as_view()),
]
