# coding: utf-8

from rest_framework.permissions import BasePermission

from procu.api.enums import QS


class WarehousePermission(BasePermission):
    def has_permission(self, request, view):
        return request.user.has_perm('api.progress_enquiry')

    def has_object_permission(self, request, view, obj):
        return QS.DRAFT < obj.status < QS.CLOSED
