# coding: utf-8

from rest_framework.permissions import BasePermission

from procu.api.enums import ES


class RequestUpdatePermission(BasePermission):
    def has_permission(self, request, view):
        if request.method == 'PATCH':
            return request.user.has_perm('api.progress_enquiry')
        return True

    def has_object_permission(self, request, view, obj):
        if request.method == 'PATCH':
            return obj.status != ES.CLOSED
        return True
