# coding: utf-8

from procu.api import enums, models
from procu.api.currency.serializers import CurrencyBriefSerializer
from procu.api.supplier.fields import RiskField
from procu.rest import serializers
from procu.rest.fields import PKPrettyField


class QueryParamsSerializer(serializers.Serializer):
    currency = PKPrettyField(
        queryset=models.Currency.objects.filter(is_deleted=False),
        serializer=CurrencyBriefSerializer,
    )
    tax = serializers.BooleanField(default=False)
    rounded = serializers.BooleanField(default=False)
    totals = serializers.BooleanField(default=False)
    replacements = serializers.BooleanField(default=False)
    response_type = serializers.ChoiceField(['json', 'xlsx'], default='json')
    snapshot = serializers.ListField(child=serializers.IntegerField())
    compare = serializers.BooleanField(default=False)


class SupplierSerializer(serializers.ModelSerializer):
    id = serializers.IntegerField(source='supplier.id')
    quote = serializers.IntegerField(source='id')
    title = serializers.CharField(source='supplier.title')
    risk = RiskField(source='supplier.risk')
    can_pay_by_card = serializers.BooleanField(
        source='supplier.can_pay_by_card'
    )
    can_checkout = serializers.SerializerMethodField()
    has_warnings = serializers.BooleanField()

    @staticmethod
    def get_can_checkout(instance):
        return enums.QS.BIDDING <= instance.status < enums.QS.CHECKOUT

    class Meta:
        model = models.Quote
        fields = (
            'id',
            'has_won',
            'quote',
            'title',
            'risk',
            'terms',
            'can_pay_by_card',
            'can_checkout',
            'has_warnings',
        )
