# coding: utf-8

from django.utils.translation import gettext_lazy as _

from procu.api import models
from procu.rest import serializers


class SnapshotListSerializer(serializers.ListSerializer):
    def to_representation(self, data):
        snapshots = super().to_representation(data)

        for i, obj in enumerate(snapshots, 1):
            obj['name'] = _('SNAPSHOTS::NAME{no}').format(no=i)

        return snapshots


class SnapshotSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.QuoteProductSnapshot
        fields = ('id', 'created_at')
        list_serializer_class = SnapshotListSerializer
