# coding: utf-8
from django.utils.translation import gettext_lazy as _
from rest_framework.response import Response

from procu.api import models
from procu.rest import generics
from procu.rest.permissions import StaffOnly
from ..views import EnquiryObjectMixin


class EnquiryTabs(EnquiryObjectMixin, generics.GenericAPIView):
    permission_classes = (StaffOnly,)
    lookup_url_kwarg = 'enquiry_id'

    def get_queryset(self):
        return models.Enquiry.objects.permitted(
            self.request.user
        ).select_related('request')

    def get(self, request, *args, **kwargs):
        enquiry = self.object
        user = request.user

        tabs = [
            {'name': 'comments', 'title': _('ENQUIRY_TAB::COMMENTS')},
            {'name': 'enquiry', 'title': _('ENQUIRY_TAB::ENQUIRY')},
        ]

        has_rfx = models.Request.objects.filter(enquiry_id=enquiry.id).exists()

        if has_rfx:
            if user.has_perm('api.retrieve_request'):
                tabs.append(
                    {'name': 'request', 'title': _('ENQUIRY_TAB::REQUEST')}
                )

            if user.has_perm('api.list_quote'):
                tabs.append(
                    {'name': 'proposals', 'title': _('ENQUIRY_TAB::PROPOSALS')}
                )

            if 'api.summary_enquiry' in enquiry.permissions(user):
                tabs.append(
                    {'name': 'summary', 'title': _('ENQUIRY_TAB::SUMMARY')}
                )

        if user.has_perm('api.list_log'):
            tabs.append(
                {'name': 'timeline', 'title': _('ENQUIRY_TAB::TIMELINE')}
            )

        return Response(tabs)
