# coding: utf-8

from django.urls import include, path, re_path

from .request.views import RequestUpdateDeadline
from .views import *


def _include(_path):
    return include('procu.api.enquiry.%s' % _path)


urlpatterns = [
    path(
        '/<int:enquiry_id>',
        include(
            [
                # New routes
                re_path(r'^/header/?$', HeaderRetrieveUpdate.as_view()),
                re_path(r'^/?$', EnquiryRetrieveUpdate.as_view()),
                path('/comments', _include('comment.urls')),
                path('/publish', _include('publish.urls')),
                path('/request', _include('request.urls')),
                path('/links', _include('links.urls')),
                path('/note', _include('note.urls')),
                path('/accesses', _include('access.urls')),
                path('/tabs', _include('tabs.urls')),
                path('/clone', _include('clone.urls')),
                path('/ticket', _include('ticket.urls')),
                path('/summary', _include('summary.urls')),
                re_path(r'^/options/?$', EnquiryOptions.as_view()),
                path('/invoices', _include('invoice.urls')),
                # Deprecated
                re_path(r'^/cancel/?$', EnquiryCancel.as_view()),
                re_path(r'^/deadline/?$', RequestUpdateDeadline.as_view()),
                path('/checkout', _include('request.checkout.urls')),
                # Old routes
                path('/quotes', _include('quote.urls')),
                # ------------------------------------------------------
            ]
        ),
    ),
    re_path(r'^_all/?$', EnquiryList.as_view()),
    re_path(r'^/?$', EnquiryCreate.as_view()),
]
