# coding: utf-8

from django.utils.translation import gettext as _
from rest_framework import status

from procu.api.utils import ErrorResponse


def error_404(request, *args, **kwargs):
    return ErrorResponse(
        msg=_('ERRORS::UNKNOWN_METHOD'), status=status.HTTP_404_NOT_FOUND
    )


def error_500(*args, **kwargs):
    return ErrorResponse(
        msg=_('ERRORS::SERVER_ERROR'),
        status=status.HTTP_500_INTERNAL_SERVER_ERROR,
    )
