# coding: utf-8

from django.conf import settings
from django.utils.translation import gettext_lazy as _

from procu.api import models
from procu.api.common.fields import TrackerChoiceField
from procu.rest import serializers


class OracleCompany(serializers.ModelSerializer):
    class Meta:
        model = models.OracleCompany
        fields = ('id', 'name', 'shortname')


class LegalEntitySerializer(serializers.ModelSerializer):
    tracker_field = TrackerChoiceField(
        max_length=31, allow_blank=True, field=settings.WAREHOUSE_ORG_FIELD
    )
    oracle_legal_entity = serializers.PKPrettyField(
        serializer=OracleCompany,
        queryset=models.OracleCompany.objects.all(),
        allow_null=True,
    )

    class Meta:
        model = models.LegalEntity
        fields = (
            'id',
            'title',
            'details',
            'oracle_legal_entity',
            'tracker_field',
            'can_pay_by_card',
            'tracker_queue',
            'is_deleted',
        )
        extra_kwargs = {'is_deleted': {'label': _('LEGAL_ENTITY::IS_DELETED')}}


class LegalEntityBrief(serializers.ModelSerializer):
    class Meta:
        model = models.LegalEntity
        fields = ('id', 'title', 'is_deleted')
