# coding: utf-8

from procu.api import models
from procu.rest import generics, mixins
from procu.rest.filters import SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import EntryPermission, ListPermission
from .serializers import LegalEntitySerializer


class LegalEntityList(generics.ListCreateAPIView):
    queryset = models.LegalEntity.objects.prefetch_related(
        'oracle_legal_entity'
    ).filter(is_deleted=False)
    serializer_class = LegalEntitySerializer
    pagination_class = PageNumberPagination
    permission_classes = (ListPermission,)
    filter_backends = (SearchFilter,)
    search_fields = ('title', 'details')


class LegalEntityEntry(
    mixins.MakeDeletedImmutable, generics.RetrieveUpdateDestroyAPIView
):

    queryset = models.LegalEntity.objects.prefetch_related(
        'oracle_legal_entity'
    )
    serializer_class = LegalEntitySerializer
    permission_classes = (EntryPermission,)
    lookup_url_kwarg = 'legal_entity_id'
