# coding: utf-8

from collections import OrderedDict

from django.utils.translation import gettext_lazy as _

from procu.api.enums import Enum

LOG_TYPES = OrderedDict(
    [
        ('create_enquiry', _('LOG_EVENT::CREATE_ENQUIRY')),
        ('update_enquiry', _('LOG_EVENT::UPDATE_ENQUIRY')),
        ('create_quote_comment', _('LOG_EVENT::CREATE_QUOTE_COMMENT')),
        ('update_quote_comment', _('LOG_EVENT::UPDATE_QUOTE_COMMENT')),
        ('remove_quote_comment', _('LOG_EVENT::REMOVE_QUOTE_COMMENT')),
        ('create_quote', _('LOG_EVENT::CREATE_QUOTE')),
        ('create_quotes', _('LOG_EVENT::CREATE_QUOTES')),
        ('update_quote', _('LOG_EVENT::UPDATE_QUOTE')),
        ('remove_quote', _('LOG_EVENT::REMOVE_QUOTE')),
        ('create_quote_product', _('LOG_EVENT::CREATE_QUOTE_PRODUCT')),
        ('update_quote_product', _('LOG_EVENT::UPDATE_QUOTE_PRODUCT')),
        ('remove_quote_product', _('LOG_EVENT::REMOVE_QUOTE_PRODUCT')),
        ('replace_quote_products', _('LOG_EVENT::REPLACE_QUOTE_PRODUCTS')),
        ('replace_quote_products_diff', _('LOG_EVENT::REPLACE_QUOTE_PRODUCTS')),
        ('create_enquiry_product', _('LOG_EVENT::CREATE_ENQUIRY_PRODUCT')),
        ('update_enquiry_product', _('LOG_EVENT::UPDATE_ENQUIRY_PRODUCT')),
        ('remove_enquiry_product', _('LOG_EVENT::REMOVE_ENQUIRY_PRODUCT')),
        ('replace_enquiry_products', _('LOG_EVENT::REPLACE_ENQUIRY_PRODUCTS')),
        (
            'replace_enquiry_products_diff',
            _('LOG_EVENT::REPLACE_ENQUIRY_PRODUCTS'),
        ),
        ('create_enquiry_comment', _('LOG_EVENT::CREATE_ENQUIRY_COMMENT')),
        ('update_enquiry_comment', _('LOG_EVENT::UPDATE_ENQUIRY_COMMENT')),
        ('remove_enquiry_comment', _('LOG_EVENT::REMOVE_ENQUIRY_COMMENT')),
        ('create_enquiry_links', _('LOG_EVENT::CREATE_ENQUIRY_LINK')),
        ('remove_enquiry_links', _('LOG_EVENT::REMOVE_ENQUIRY_LINK')),
        ('create_invoice', _('LOG_EVENT::CREATE_INVOICE')),
        ('update_invoice', _('LOG_EVENT::UPDATE_INVOICE')),
        ('remove_invoice', _('LOG_EVENT::REMOVE_INVOICE')),
        ('update_access', _('LOG_EVENT::UPDATE_ACCESS')),
        ('create_request', _('LOG_EVENT::CREATE_REQUEST')),
        ('update_request', _('LOG_EVENT::UPDATE_REQUEST')),
        ('replace_request_products', _('LOG_EVENT::REPLACE_REQUEST_PRODUCTS')),
    ]
)


class LOG_GROUPS(Enum):

    ENQUIRY = (
        'create_enquiry',
        'update_enquiry',
        'create_enquiry_links',
        'remove_enquiry_links',
        'update_access',
    )
    QUOTE = ('create_quote', 'create_quotes', 'update_quote', 'remove_quote')
    QUOTE_PRODUCT = (
        'create_quote_product',
        'update_quote_product',
        'remove_quote_product',
        'replace_quote_products',
        'replace_quote_products_diff',
    )
    ENQUIRY_PRODUCT = (
        'create_enquiry_product',
        'update_enquiry_product',
        'remove_enquiry_product',
        'replace_enquiry_products',
        'replace_enquiry_products_diff',
    )
    ENQUIRY_COMMENT = (
        'create_enquiry_comment',
        'update_enquiry_comment',
        'remove_enquiry_comment',
    )
    QUOTE_COMMENT = (
        'create_quote_comment',
        'update_quote_comment',
        'remove_quote_comment',
    )

    ENQUIRY_LINK = ('create_enquiry_links', 'remove_enquiry_links')

    INVOICE = ('create_invoice', 'update_invoice', 'remove_invoice')

    REQUEST = ('create_request', 'update_request')

    keys = OrderedDict(
        [
            (ENQUIRY, 'enquiry'),
            (QUOTE, 'quote'),
            (QUOTE_PRODUCT, 'quote_product'),
            (ENQUIRY_PRODUCT, 'enquiry_product'),
            (ENQUIRY_COMMENT, 'enquiry_comment'),
            (QUOTE_COMMENT, 'quote_comment'),
            (ENQUIRY_LINK, 'enquiry_link'),
            (INVOICE, 'invoice'),
            (REQUEST, 'request'),
        ]
    )

    i18n = OrderedDict(
        [
            (ENQUIRY, _('LOG_GROUP::ENQUIRY')),
            (QUOTE, _('LOG_GROUP::QUOTE')),
            (QUOTE_PRODUCT, _('LOG_GROUP::QUOTE_PRODUCT')),
            (ENQUIRY_PRODUCT, _('LOG_GROUP::ENQUIRY_PRODUCT')),
            (ENQUIRY_COMMENT, _('LOG_GROUP::ENQUIRY_COMMENT')),
            (QUOTE_COMMENT, _('LOG_GROUP::QUOTE_COMMENT')),
            (ENQUIRY_LINK, _('LOG_GROUP::ENQUIRY_LINK')),
            (INVOICE, _('LOG_GROUP::INVOICE')),
            (REQUEST, _('LOG_GROUP::REQUEST')),
        ]
    )
