# coding: utf-8

from procu.rest.filters import BaseFilterBackend, BaseListFilter
from .constants import LOG_GROUPS


class EnquiryFilter(BaseListFilter):
    query_param = 'enquiry'
    field = 'enquiry'


class UserFilter(BaseListFilter):
    query_param = 'user'
    field = 'user'


class GroupFilter(BaseFilterBackend):
    def filter_queryset(self, request, queryset, view):

        groups = request.GET.getlist('group')
        groups = set(LOG_GROUPS.keys.values()).intersection(groups)

        if not groups:
            return queryset

        only_types = set()

        for group_types in map(LOG_GROUPS.get_by_key, groups):
            only_types = only_types.union(group_types)

        return queryset.filter(type__in=only_types)
