# coding: utf-8

from procu.api import models
from procu.rest import generics
from procu.rest.pagination import NextPagination
from procu.rest.permissions import ListPermission
from .serializers import Log
from .filters import EnquiryFilter, UserFilter, GroupFilter


class LogList(generics.ListAPIView):
    serializer_class = Log
    pagination_class = NextPagination
    permission_classes = (ListPermission,)

    filter_backends = (EnquiryFilter, UserFilter, GroupFilter)

    def get_queryset(self):
        return (
            models.Log.objects.permitted(self.request.user)
            .select_related('user', 'quote', 'quote__supplier', 'enquiry')
            .only(
                'id',
                'type',
                'happened_at',
                'new',
                'old',
                'data',
                'enquiry__id',
                'enquiry__subject',
                'quote__id',
                'quote__supplier__title',
                'quote__supplier__title',
                'user__id',
                'user__username',
                'user__email',
                'user__first_name',
                'user__last_name',
                'user__is_staff',
                'user__is_deleted',
            )
            .distinct('id')
            .order_by('-id')
        )
