# coding: utf-8

from collections import defaultdict

from django.core.management.base import BaseCommand
from rest_framework.schemas.generators import EndpointEnumerator


class Command(BaseCommand):
    help = ''

    def add_arguments(self, parser):
        pass

    def handle(self, *args, **options):

        endpoints = defaultdict(list)

        enumerator = EndpointEnumerator().get_api_endpoints()

        for path, method, _ in enumerator:
            endpoints[path].append(method)

        items = sorted(endpoints.items())

        for path, methods in items:
            print('{:<19}  {:<}'.format(', '.join(methods), path))
