# coding: utf-8

from datetime import datetime

from django.conf import settings
from django.core.cache import cache
from django.core.management.base import BaseCommand, CommandError

from procu.api.utils import get_maintenance
from procu.rest.utils.duration import parse_duration


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument('positionals', nargs='*')

    help = 'Activate or deactivate maintenance mode.'

    def handle(self, *args, **kwargs):

        options = kwargs['positionals']

        if len(options) > 0:

            state = options[0]

            if state == 'off':
                cache.set(settings.SWITCH_MAINTENANCE, None)

            elif state == 'on':
                try:
                    downtime = options[1]
                except IndexError:
                    raise CommandError('Downtime duration is required')

                downtime = parse_duration(downtime)

                if downtime is None:
                    raise CommandError('Could not parse downtime duration')

                cache.set(
                    settings.SWITCH_MAINTENANCE, (datetime.now(), downtime)
                )

            else:
                raise CommandError("State must be either `on' or `off'")

        # Print maintenance information
        maintenance = get_maintenance()

        if maintenance:
            started_at, downtime = maintenance
            print(f'Maintenance is on for {downtime}')
        else:
            print('Maintenance is off')
