# coding: utf-8

from django.core.management.base import BaseCommand

from procu.api import models


class Command(BaseCommand):
    help = ''

    def add_arguments(self, parser):
        parser.add_argument('--show', action='store_true')

    def handle(self, *args, **options):

        inns = {}
        blacklist = set()

        qs = models.OracleSupplier.objects.values_list('id', 'inn').filter(
            is_deleted=False
        )

        for id_, inn in qs:
            x = inns.pop(inn, None)
            if x is not None:
                blacklist.add(inn)

            if inn not in blacklist:
                inns[inn] = id_

        qs = models.Supplier.objects.only('id', 'title', 'vat_id')

        for supplier in qs:
            oebs_supplier_id = inns.get(supplier.vat_id)

            if oebs_supplier_id is None:
                continue

            print(supplier.id, supplier.title, supplier.vat_id)

            if options.get('show', False):
                supplier.oracle_supplier_id = oebs_supplier_id
                supplier.save(update_fields=['oracle_supplier_id'])
