# coding: utf-8

from django.conf import settings
from django.contrib.auth.models import Group, Permission
from django.core.cache import cache
from django.core.management.base import BaseCommand


def get_permissions(model, perms):

    perm_objects = []

    for perm in perms:
        try:
            perm = Permission.objects.get_by_natural_key(
                '%s_%s' % (perm, model), 'api', model
            )
            perm_objects.append(perm)

        except Permission.DoesNotExist:
            print(perm, model)
            raise

    return perm_objects


class Command(BaseCommand):
    help = ''

    def add_arguments(self, parser):
        pass

    def handle(self, *args, **options):

        for group_name, info in settings.ROLES.items():
            models = info['permissions']

            group, _ = Group.objects.get_or_create(name=group_name)
            group.permissions.clear()

            for model, perms in models:

                for perm in get_permissions(model, perms):
                    group.permissions.add(perm)

        cache.clear()
