# coding: utf-8

from django.conf import settings
from django.core.cache import cache
from django.core.management.base import BaseCommand

from procu.api.utils import is_readonly


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument('positionals', nargs='*')

    help = 'Activate or deactivate maintenance mode.'

    def handle(self, *args, **kwargs):

        options = kwargs['positionals']

        if len(options) > 0:
            state = options[0] == 'on'
            cache.set(settings.SWITCH_READONLY, state)

        # Print readonly information
        state = is_readonly()
        print('Readonly mode is %s' % ('on' if state else 'off'))
