# Generated by Django 2.0.6 on 2018-08-08 16:37

import datetime

import django.contrib.auth.validators
import django.contrib.postgres.fields
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import procu.api.managers
import procu.api.models
import procu.soft_delete.models
import procu.wf.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [('auth', '0009_alter_user_last_name_max_length')]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'password',
                    models.CharField(max_length=128, verbose_name='password'),
                ),
                (
                    'last_login',
                    models.DateTimeField(
                        blank=True, null=True, verbose_name='last login'
                    ),
                ),
                (
                    'is_superuser',
                    models.BooleanField(
                        default=False,
                        help_text='Designates that this user has all permissions without explicitly assigning them.',
                        verbose_name='superuser status',
                    ),
                ),
                (
                    'username',
                    models.CharField(
                        error_messages={
                            'unique': 'A user with that username already exists.'
                        },
                        help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
                        max_length=150,
                        unique=True,
                        validators=[
                            django.contrib.auth.validators.UnicodeUsernameValidator()
                        ],
                        verbose_name='username',
                    ),
                ),
                (
                    'is_staff',
                    models.BooleanField(
                        default=False,
                        help_text='Designates whether the user can log into this admin site.',
                        verbose_name='staff status',
                    ),
                ),
                (
                    'is_active',
                    models.BooleanField(
                        default=True,
                        help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.',
                        verbose_name='active',
                    ),
                ),
                (
                    'date_joined',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        verbose_name='date joined',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'email',
                    models.EmailField(
                        blank=True,
                        max_length=254,
                        verbose_name='MODEL_USER::EMAIL',
                    ),
                ),
                (
                    'first_name',
                    models.CharField(
                        blank=True,
                        max_length=100,
                        verbose_name='MODEL_USER::FIRST_NAME',
                    ),
                ),
                (
                    'last_name',
                    models.CharField(
                        blank=True,
                        max_length=100,
                        verbose_name='MODEL_USER::LAST_NAME',
                    ),
                ),
                (
                    'comment',
                    models.TextField(
                        blank=True, verbose_name='MODEL_USER::COMMENT'
                    ),
                ),
                (
                    'sex',
                    models.IntegerField(
                        choices=[(0, 'unknown'), (1, 'male'), (2, 'female')],
                        default=0,
                        verbose_name='MODEL_USER::SEX',
                    ),
                ),
                (
                    'language',
                    models.CharField(
                        blank=True,
                        max_length=7,
                        verbose_name='MODEL_USER::LANGUAGE',
                    ),
                ),
                (
                    'info',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_USER::INFO'
                    ),
                ),
                (
                    'is_cold',
                    models.BooleanField(
                        default=False, verbose_name='MODEL_USER::IS_COLD'
                    ),
                ),
                (
                    'is_subscribed_created',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_USER::IS_SUBSCRIBED_CREATED',
                    ),
                ),
                (
                    'sort_quotes_by_updated',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_USER::SORT_QUOTES_BY_UPDATED',
                    ),
                ),
                (
                    'signature',
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name='MODEL_USER::SIGNATURE',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
            managers=[('objects', procu.api.managers.UserManager())],
        ),
        migrations.CreateModel(
            name='Address',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'label',
                    models.CharField(
                        blank=True,
                        max_length=255,
                        verbose_name='MODEL_ADDRESS::LABEL',
                    ),
                ),
                ('text', models.TextField(verbose_name='MODEL_ADDRESS::TEXT')),
                (
                    'tracker_location',
                    models.CharField(
                        blank=True,
                        max_length=31,
                        verbose_name='MODEL_ADDRESS::TRACKER_LOCATION',
                    ),
                ),
                (
                    'tracker_components',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=63),
                        default=list,
                        size=None,
                        verbose_name='MODEL_ADDRESS::TRACKER_COMPONENTS',
                    ),
                ),
                (
                    'comment',
                    models.TextField(
                        blank=True, verbose_name='MODEL_ADDRESS::COMMENT'
                    ),
                ),
                (
                    'contacts',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_ADDRESS::CONTACTS'
                    ),
                ),
                (
                    'geo',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=None,
                        null=True,
                        verbose_name='MODEL_ADDRESS::GEO',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='Attachment',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('filename', models.CharField(blank=True, max_length=255)),
                (
                    'file',
                    models.FileField(upload_to=procu.api.models.get_filename),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='AuthToken',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'token',
                    models.TextField(
                        default=procu.api.models.gen_uuid, unique=True
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Currency',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'code',
                    models.CharField(
                        blank=True,
                        max_length=6,
                        verbose_name='MODEL_CURRENCY::CODE',
                    ),
                ),
                (
                    'char_code',
                    models.CharField(
                        blank=True,
                        max_length=4,
                        verbose_name='MODEL_CURRENCY::CHAR_CODE',
                    ),
                ),
                (
                    'prefix',
                    models.CharField(
                        blank=True,
                        max_length=10,
                        verbose_name='MODEL_CURRENCY::PREFIX',
                    ),
                ),
                (
                    'suffix',
                    models.CharField(
                        blank=True,
                        max_length=10,
                        verbose_name='MODEL_CURRENCY::SUFFIX',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=127, verbose_name='MODEL_CURRENCY::NAME'
                    ),
                ),
                (
                    'nominal',
                    models.PositiveIntegerField(
                        default=1, verbose_name='MODEL_CURRENCY::NOMINAL'
                    ),
                ),
                (
                    'rate',
                    models.DecimalField(
                        decimal_places=4,
                        max_digits=10,
                        verbose_name='MODEL_CURRENCY::RATE',
                    ),
                ),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='Dashboard',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                ('name', models.TextField(verbose_name='DASHBOARD::NAME')),
                (
                    'is_public',
                    models.BooleanField(
                        default=False, verbose_name='DASHBOARD::IS_PUBLIC'
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='DashboardWidget',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'name',
                    models.TextField(verbose_name='DASHBOARDWIDGET::NAME'),
                ),
                (
                    'filter',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='DASHBOARDWIDGET::FILTER'
                    ),
                ),
                (
                    'limit',
                    models.IntegerField(verbose_name='DASHBOARDWIDGET::LIMIT'),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Discount',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'value',
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=5,
                        verbose_name='MODEL_DISCOUNT::VALUE',
                    ),
                ),
                (
                    'dates',
                    django.contrib.postgres.fields.ranges.DateRangeField(
                        verbose_name='MODEL_DISCOUNT::DATES'
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='Enquiry',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        null=True,
                        verbose_name='MODEL_ENQUIRY::KEY',
                    ),
                ),
                (
                    'subject',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ENQUIRY::SUBJECT'
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_ENQUIRY::CREATED_AT',
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_ENQUIRY::UPDATED_AT',
                    ),
                ),
                (
                    'deadline_at',
                    models.DateTimeField(
                        null=True, verbose_name='MODEL_ENQUIRY::DEADLINE_AT'
                    ),
                ),
                (
                    'comment',
                    models.TextField(
                        blank=True, verbose_name='MODEL_ENQUIRY::COMMENT'
                    ),
                ),
                (
                    'delivery_at',
                    models.DateField(
                        null=True, verbose_name='MODEL_ENQUIRY::DELIVERY_AT'
                    ),
                ),
                (
                    'priority',
                    models.IntegerField(
                        choices=[
                            (100, 'minor'),
                            (200, 'low'),
                            (300, 'normal'),
                            (400, 'critical'),
                            (500, 'blocker'),
                        ],
                        default=300,
                        verbose_name='MODEL_ENQUIRY::PRIORITY',
                    ),
                ),
                (
                    'no_replacement',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_ENQUIRY::NO_REPLACEMENT',
                    ),
                ),
                (
                    'summary',
                    models.TextField(
                        blank=True, verbose_name='MODEL_ENQUIRY::SUMMARY'
                    ),
                ),
                (
                    'status',
                    models.IntegerField(
                        choices=[
                            (150, 'draft'),
                            (210, 'bidding'),
                            (220, 'review'),
                            (230, 'checkout'),
                            (240, 'shipped'),
                            (250, 'closed'),
                        ],
                        default=150,
                        verbose_name='MODEL_ENQUIRY::STATUS',
                    ),
                ),
                (
                    'reason',
                    models.IntegerField(
                        choices=[
                            (1000, 'none'),
                            (1100, 'delivered'),
                            (1300, 'declined'),
                            (1400, 'ignored'),
                            (1500, 'cancelled'),
                        ],
                        default=1000,
                        verbose_name='MODEL_ENQUIRY::REASON',
                    ),
                ),
                (
                    'internal_comment',
                    models.TextField(
                        blank=True,
                        verbose_name='MODEL_ENQUIRY::INTERNAL_COMMENT',
                    ),
                ),
                (
                    'due_at',
                    models.DateField(
                        null=True, verbose_name='MODEL_ENQUIRY::DUE_AT'
                    ),
                ),
                (
                    'initial_products',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=list,
                        verbose_name='MODEL_ENQUIRY::INITIAL_PRODUCTS',
                    ),
                ),
                (
                    'extra',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_ENQUIRY::EXTRA'
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                    'checkout',
                    'progress',
                    'summary',
                    'summary_final',
                    'all',
                ),
            },
        ),
        migrations.CreateModel(
            name='EnquiryAccess',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'sources',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.IntegerField(
                            choices=[
                                (100, 'type'),
                                (200, 'cfo'),
                                (300, 'author'),
                                (400, 'assignee'),
                                (500, 'access'),
                            ]
                        ),
                        default=list,
                        size=None,
                        verbose_name='MODEL_ENQUIRYACCESS::SOURCES',
                    ),
                ),
                (
                    'is_subscribed',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_ENQUIRYACCESS::IS_SUBSCRIBED',
                    ),
                ),
                (
                    'allow_quote_comments',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_ENQUIRYACCESS::ALLOW_QUOTE_COMMENTS',
                    ),
                ),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='EnquiryCategory',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ENQUIRY_TYPE::NAME'
                    ),
                ),
                (
                    'sourcing_time',
                    models.DurationField(
                        default=datetime.timedelta,
                        verbose_name='MODEL_ENQUIRY_TYPE::SOURCING_TIME',
                    ),
                ),
                (
                    'completion_time',
                    models.DurationField(
                        default=datetime.timedelta,
                        verbose_name='MODEL_ENQUIRY_TYPE::COMPLETION_TIME',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='EnquiryComment',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    'is_from_email',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'message',
                    procu.wf.fields.WFTextField(
                        blank=True,
                        verbose_name='MODEL_ENQUIRY_COMMENT::MESSAGE',
                        wf_config='intranet',
                    ),
                ),
                (
                    'message_html',
                    models.TextField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='EnquiryNote',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'text',
                    models.TextField(verbose_name='MODEL_ENQUIRYNOTE::TEXT'),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_ENQUIRYNOTE::CREATED_AT',
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_ENQUIRYNOTE::UPDATED_AT',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='EnquiryProduct',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255,
                        verbose_name='MODEL_ENQUIRY_PRODUCT::NAME',
                    ),
                ),
                (
                    'qty',
                    models.PositiveIntegerField(
                        verbose_name='MODEL_ENQUIRY_PRODUCT::QTY'
                    ),
                ),
                (
                    'comment',
                    models.TextField(
                        blank=True,
                        verbose_name='MODEL_ENQUIRY_PRODUCT::COMMENT',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='EnquirySaving',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'saving',
                    models.DecimalField(
                        decimal_places=4, max_digits=14, null=True
                    ),
                ),
                (
                    'best_price',
                    models.DecimalField(
                        decimal_places=4, max_digits=14, null=True
                    ),
                ),
                (
                    'expected_price',
                    models.DecimalField(
                        decimal_places=4, max_digits=14, null=True
                    ),
                ),
                (
                    'note',
                    models.IntegerField(
                        choices=[
                            (100, 'none'),
                            (200, 'closed_not_delivered'),
                            (300, 'no_winners'),
                            (400, 'multiple_winners'),
                            (500, 'partial_offers'),
                            (600, 'non_trivial_winner'),
                            (700, 'less_than_two_offers'),
                            (800, 'invalid_prices'),
                            (900, 'negative_saving'),
                        ],
                        default=100,
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='FormData',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('data', django.contrib.postgres.fields.jsonb.JSONField()),
                (
                    'key',
                    models.TextField(
                        default=procu.api.models.gen_uuid, unique=True
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        auto_now_add=True,
                        verbose_name='MODEL_INVOICE::CREATED_AT',
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        auto_now=True, verbose_name='MODEL_INVOICE::UPDATED_AT'
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='InvoiceProduct',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'name',
                    models.TextField(verbose_name='MODEL_INVOICEPRODUCT::NAME'),
                ),
                (
                    'qty',
                    models.DecimalField(
                        decimal_places=3,
                        max_digits=12,
                        verbose_name='MODEL_INVOICEPRODUCT::QTY',
                    ),
                ),
                (
                    'price',
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=12,
                        verbose_name='MODEL_INVOICEPRODUCT::PRICE',
                    ),
                ),
                (
                    'price_for',
                    models.IntegerField(
                        choices=[(100, 'unit'), (200, 'total')],
                        verbose_name='MODEL_INVOICEPRODUCT::PRICE_FOR',
                    ),
                ),
                (
                    'tax',
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=12,
                        verbose_name='MODEL_INVOICEPRODUCT::TAX',
                    ),
                ),
                (
                    'tax_mode',
                    models.IntegerField(
                        choices=[
                            (100, 'included'),
                            (200, 'excluded'),
                            (300, 'untaxed'),
                        ],
                        verbose_name='MODEL_INVOICEPRODUCT::TAX_MODE',
                    ),
                ),
                (
                    'delivery_expected_at',
                    models.DateField(
                        null=True,
                        verbose_name='MODEL_INVOICEPRODUCT::DELIVERY_EXPECTED_AT',
                    ),
                ),
                (
                    'delivery_happened_at',
                    models.DateField(
                        null=True,
                        verbose_name='MODEL_INVOICEPRODUCT::DELIVERY_HAPPENED_AT',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='LegalEntity',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'title',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_LEGAL_ENTITY::TITLE'
                    ),
                ),
                (
                    'details',
                    models.TextField(
                        blank=True, verbose_name='MODEL_LEGAL_ENTITY::DETAILS'
                    ),
                ),
                (
                    'tracker_field',
                    models.CharField(
                        blank=True,
                        max_length=31,
                        verbose_name='MODEL_LEGAL_ENTITY::TRACKER_FIELD',
                    ),
                ),
                (
                    'can_pay_by_card',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_LEGAL_ENTITY::CAN_PAY_BY_CARD',
                    ),
                ),
                (
                    'tracker_queue',
                    models.CharField(
                        blank=True,
                        max_length=31,
                        verbose_name='MODEL_LEGAL_ENTITY::TRACKER_QUEUE',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='Link',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('key', models.CharField(max_length=63, null=True)),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='LinkObject',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'type',
                    models.IntegerField(
                        choices=[(100, 'procu'), (200, 'tracker')]
                    ),
                ),
                ('object_id', models.CharField(max_length=63)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField()),
                (
                    'updated_at',
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ('fetch_attempt', models.IntegerField(default=0)),
                ('fetch_at', models.DateTimeField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Log',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('happened_at', models.DateTimeField(auto_now_add=True)),
                ('notify_at', models.DateTimeField(null=True)),
                ('is_sent', models.BooleanField(default=False)),
                ('type', models.CharField(blank=True, max_length=255)),
                ('template', models.CharField(blank=True, max_length=255)),
                ('fields', models.TextField(blank=True, default='[]')),
                ('data', models.TextField(blank=True, default='{}')),
                ('old', models.TextField(blank=True, default='{}')),
                ('new', models.TextField(blank=True, default='{}')),
                (
                    'enquiry',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='api.Enquiry',
                    ),
                ),
                (
                    'enquiry_product',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='api.EnquiryProduct',
                    ),
                ),
            ],
            options={
                'ordering': ('-pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='OracleBudgetLine',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.TextField(
                        unique=True, verbose_name='MODEL_ORACLEBUDGETLINE::KEY'
                    ),
                ),
                (
                    'name',
                    models.TextField(
                        verbose_name='MODEL_ORACLEBUDGETLINE::NAME'
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleCFO',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        unique=True,
                        verbose_name='MODEL_ORACLECFO::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ORACLECFO::NAME'
                    ),
                ),
                (
                    'users',
                    models.ManyToManyField(
                        blank=True,
                        related_name='cfos',
                        to=settings.AUTH_USER_MODEL,
                        verbose_name='MODEL_ORACLECFO::USERS',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleCompany',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'orgid',
                    models.IntegerField(
                        unique=True, verbose_name='MODEL_ORACLECOMPANY::ORGID'
                    ),
                ),
                (
                    'inn',
                    models.CharField(
                        max_length=15,
                        null=True,
                        verbose_name='MODEL_ORACLECOMPANY::INN',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ORACLECOMPANY::NAME'
                    ),
                ),
                (
                    'shortname',
                    models.CharField(
                        max_length=15,
                        verbose_name='MODEL_ORACLECOMPANY::SHORTNAME',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleCurrency',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=15,
                        unique=True,
                        verbose_name='MODEL_ORACLECURRENCY::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255,
                        verbose_name='MODEL_ORACLECURRENCY::NAME',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleImportLog',
            fields=[
                ('key', models.TextField(primary_key=True, serialize=False)),
                ('last_id', models.IntegerField(default=0)),
                ('last_updated_at', models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name='OracleMVP',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        unique=True,
                        verbose_name='MODEL_ORACLEMVP::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ORACLEMVP::NAME'
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleProductLine',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        unique=True,
                        verbose_name='MODEL_ORACLEPRODUCTLINE::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255,
                        verbose_name='MODEL_ORACLEPRODUCTLINE::NAME',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleProgram',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        unique=True,
                        verbose_name='MODEL_ORACLEPROGRAM::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ORACLEPROGRAM::NAME'
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleProject',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        unique=True,
                        verbose_name='MODEL_ORACLEPROJECT::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ORACLEPROJECT::NAME'
                    ),
                ),
                (
                    'company',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='projects',
                        to='api.OracleCompany',
                        verbose_name='MODEL_ORACLEPROJECT::COMPANY',
                    ),
                ),
                (
                    'program',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='projects',
                        to='api.OracleProgram',
                        verbose_name='MODEL_ORACLEPROJECT::PROGRAM',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OraclePurchaseGroup',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.IntegerField(
                        unique=True,
                        verbose_name='MODEL_ORACLEPURCHASEGROUP::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255,
                        verbose_name='MODEL_ORACLEPURCHASEGROUP::NAME',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleService',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.TextField(
                        blank=True,
                        unique=True,
                        verbose_name='MODEL_ORACLESERVICE::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ORACLESERVICE::NAME'
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleSubSystem',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.TextField(
                        unique=True, verbose_name='MODEL_ORACLESUBSYSTEM::KEY'
                    ),
                ),
                (
                    'name',
                    models.TextField(
                        verbose_name='MODEL_ORACLESUBSYSTEM::NAME'
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleSupplier',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.TextField(
                        unique=True, verbose_name='MODEL_ORACLESUPPLIER::KEY'
                    ),
                ),
                (
                    'name',
                    models.TextField(verbose_name='MODEL_ORACLESUPPLIER::NAME'),
                ),
                (
                    'full_name',
                    models.TextField(
                        verbose_name='MODEL_ORACLESUPPLIER::FULL_NAME'
                    ),
                ),
                (
                    'inn',
                    models.TextField(
                        null=True, verbose_name='MODEL_ORACLESUPPLIER::INN'
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleSystem',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.TextField(
                        unique=True, verbose_name='MODEL_ORACLESYSTEM::KEY'
                    ),
                ),
                (
                    'name',
                    models.TextField(verbose_name='MODEL_ORACLESYSTEM::NAME'),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='OracleTask',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        unique=True,
                        verbose_name='MODEL_ORACLETASK::KEY',
                    ),
                ),
                (
                    'name',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_ORACLETASK::NAME'
                    ),
                ),
                (
                    'project',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='tasks',
                        to='api.OracleProject',
                        verbose_name='MODEL_ORACLETASK::PROJECT',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='Quote',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'payment_terms',
                    models.TextField(
                        blank=True, verbose_name='MODEL_QUOTE::TERMS'
                    ),
                ),
                (
                    'has_offer',
                    models.BooleanField(
                        default=False, verbose_name='MODEL_QUOTE::HAS_OFFER'
                    ),
                ),
                (
                    'has_won',
                    models.BooleanField(
                        default=False, verbose_name='MODEL_QUOTE::HAS_WON'
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        verbose_name='MODEL_QUOTE::CREATED_AT',
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        verbose_name='MODEL_QUOTE::UPDATED_AT',
                    ),
                ),
                (
                    'deadline_at',
                    models.DateTimeField(
                        null=True, verbose_name='MODEL_QUOTE::DEADLINE_AT'
                    ),
                ),
                (
                    'delivery_at',
                    models.DateField(
                        null=True, verbose_name='MODEL_QUOTE::DELIVERY_AT'
                    ),
                ),
                (
                    'delivery_orders',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, max_length=31),
                        default=list,
                        size=None,
                        verbose_name='MODEL_QUOTE::DELIVERY_ORDERS',
                    ),
                ),
                (
                    'status',
                    models.IntegerField(
                        choices=[
                            (150, 'draft'),
                            (210, 'bidding'),
                            (220, 'review'),
                            (230, 'checkout'),
                            (240, 'shipped'),
                            (250, 'closed'),
                        ],
                        default=150,
                        verbose_name='MODEL_QUOTE::STATUS',
                    ),
                ),
                (
                    'reason',
                    models.IntegerField(
                        choices=[
                            (1000, 'none'),
                            (1100, 'delivered'),
                            (1300, 'declined'),
                            (1400, 'ignored'),
                            (1500, 'cancelled'),
                        ],
                        default=1000,
                        verbose_name='MODEL_QUOTE::REASON',
                    ),
                ),
                (
                    'terms',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_QUOTE::TERMS'
                    ),
                ),
                (
                    'enquiry',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='quotes',
                        to='api.Enquiry',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('with_deleted', django.db.models.manager.Manager()),
                ('objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='QuoteComment',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                ('message', models.TextField(blank=True)),
                (
                    'message_html',
                    models.TextField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                (
                    'is_from_email',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'is_suspicious',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'author',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'quote',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='comments',
                        to='api.Quote',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='QuoteProduct',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                ('tax', models.DecimalField(decimal_places=2, max_digits=12)),
                ('is_tax_included', models.BooleanField(default=True)),
                ('name', models.CharField(blank=True, max_length=255)),
                ('qty', models.PositiveIntegerField()),
                (
                    'price',
                    models.DecimalField(
                        decimal_places=2, max_digits=12, null=True
                    ),
                ),
                ('comment', models.TextField(blank=True)),
                ('delivery_time', models.CharField(blank=True, max_length=255)),
                ('is_replacement', models.BooleanField(default=False)),
                ('is_per_unit', models.BooleanField(default=True)),
                (
                    'currency',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='api.Currency',
                    ),
                ),
                (
                    'enquiry_product',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='quote_products',
                        to='api.EnquiryProduct',
                    ),
                ),
                (
                    'parent',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='api.QuoteProduct',
                    ),
                ),
                (
                    'quote',
                    procu.soft_delete.models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='products',
                        to='api.Quote',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='QuoteProductSnapshot',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    'enquiry',
                    procu.soft_delete.models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='snapshots',
                        to='api.Enquiry',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='QuoteRef',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'ref',
                    models.TextField(
                        default=procu.api.models.gen_uuid, unique=True
                    ),
                ),
                ('counter', models.IntegerField()),
                ('created_at', models.DateTimeField(auto_now=True)),
                (
                    'quote',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='refs',
                        to='api.Quote',
                    ),
                ),
                (
                    'user',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='QuoteReply',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'token',
                    models.TextField(
                        default=procu.api.models.gen_uuid, unique=True
                    ),
                ),
                (
                    'quote',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='api.Quote',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=31,
                        null=True,
                        verbose_name='MODEL_REQUEST::KEY',
                    ),
                ),
                (
                    'subject',
                    models.TextField(verbose_name='MODEL_REQUEST::SUBJECT'),
                ),
                (
                    'no_replacement',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_REQUEST::NO_REPLACEMENT',
                    ),
                ),
                (
                    'deadline_at',
                    models.DateTimeField(
                        null=True, verbose_name='MODEL_REQUEST::DEADLINE_AT'
                    ),
                ),
                (
                    'description',
                    models.TextField(
                        blank=True, verbose_name='MODEL_REQUEST::DESCRIPTION'
                    ),
                ),
                (
                    'status',
                    models.IntegerField(
                        choices=[
                            (150, 'draft'),
                            (210, 'bidding'),
                            (220, 'review'),
                            (230, 'checkout'),
                            (240, 'shipped'),
                            (250, 'closed'),
                        ],
                        default=150,
                        verbose_name='MODEL_REQUEST::STATUS',
                    ),
                ),
                (
                    'reason',
                    models.IntegerField(
                        choices=[
                            (1000, 'none'),
                            (1100, 'delivered'),
                            (1300, 'declined'),
                            (1400, 'ignored'),
                            (1500, 'cancelled'),
                        ],
                        default=1000,
                        verbose_name='MODEL_REQUEST::REASON',
                    ),
                ),
                (
                    'summary',
                    models.TextField(
                        blank=True, verbose_name='MODEL_REQUEST::SUMMARY'
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_REQUEST::CREATED_AT',
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_REQUEST::UPDATED_AT',
                    ),
                ),
                (
                    'address',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to='api.Address',
                        verbose_name='MODEL_REQUEST::ADDRESS',
                    ),
                ),
                (
                    'enquiry',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='request',
                        to='api.Enquiry',
                    ),
                ),
                (
                    'legal_entity',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='api.LegalEntity',
                        verbose_name='MODEL_REQUEST::LEGAL_ENTITY',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='SCSTicket',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('ticket', models.CharField(max_length=127)),
                (
                    'quote',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='api.Quote',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='SparkCache',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'vat_id',
                    models.CharField(
                        max_length=127,
                        unique=True,
                        verbose_name='MODEL_SPARKCACHE::VAT_ID',
                    ),
                ),
                (
                    'risk_data',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_SPARKCACHE::RISK_DATA'
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        verbose_name='MODEL_SPARKCACHE::UPDATED_AT',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'title',
                    models.CharField(
                        max_length=255, verbose_name='MODEL_SUPPLIER::TITLE'
                    ),
                ),
                (
                    'legal_name',
                    models.CharField(
                        blank=True,
                        max_length=255,
                        verbose_name='MODEL_SUPPLIER::LEGAL_NAME',
                    ),
                ),
                (
                    'has_contract',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_SUPPLIER::HAS_CONTRACT',
                    ),
                ),
                (
                    'payment_terms',
                    models.TextField(
                        blank=True, verbose_name='MODEL_SUPPLIER::TERMS'
                    ),
                ),
                (
                    'vat_id',
                    models.CharField(
                        blank=True,
                        max_length=127,
                        verbose_name='MODEL_SUPPLIER::VAT_ID',
                    ),
                ),
                (
                    'comment',
                    models.TextField(
                        blank=True, verbose_name='MODEL_SUPPLIER::COMMENT'
                    ),
                ),
                (
                    'info',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_SUPPLIER::INFO'
                    ),
                ),
                (
                    'risk',
                    models.IntegerField(
                        choices=[
                            (100, 'unknown'),
                            (200, 'fetching'),
                            (300, 'low'),
                            (400, 'moderate'),
                            (500, 'high'),
                        ],
                        default=100,
                        verbose_name='MODEL_SUPPLIER::RISK',
                    ),
                ),
                (
                    'risk_data',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_SUPPLIER::RISK_DATA'
                    ),
                ),
                (
                    'risk_updated_at',
                    models.DateTimeField(
                        null=True,
                        verbose_name='MODEL_SUPPLIER::RISK_UPDATED_AT',
                    ),
                ),
                (
                    'is_cold',
                    models.BooleanField(
                        default=False, verbose_name='MODEL_SUPPLIER::IS_COLD'
                    ),
                ),
                (
                    'can_pay_by_card',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_SUPPLIER::CAN_PAY_BY_CARD',
                    ),
                ),
                (
                    'terms',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name='MODEL_SUPPLIER::TERMS'
                    ),
                ),
                (
                    'secrets',
                    models.TextField(
                        blank=True, verbose_name='MODEL_SUPPLIER::SECRETS'
                    ),
                ),
                (
                    'author',
                    procu.soft_delete.models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                        verbose_name='MODEL_SUPPLIER::AUTHOR',
                    ),
                ),
                (
                    'oracle_supplier',
                    procu.soft_delete.models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='+',
                        to='api.OracleSupplier',
                        verbose_name='MODEL_SUPPLIER::ORACLE_SUPPLIER',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='SupplierTag',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'label',
                    models.CharField(
                        max_length=127,
                        unique=True,
                        verbose_name='MODEL_SUPPLIER_TAG::LABEL',
                    ),
                ),
                (
                    'comment',
                    models.TextField(
                        blank=True, verbose_name='MODEL_SUPPLIER_TAG::COMMENT'
                    ),
                ),
                (
                    'is_hidden',
                    models.BooleanField(
                        default=False,
                        verbose_name='MODEL_SUPPLIER_TAG::IS_HIDDEN',
                    ),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='SupplierWarning',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                (
                    'message',
                    models.TextField(
                        verbose_name='MODEL_SUPPLIERWARNING::TEXT'
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_SUPPLIERWARNING::CREATED_AT',
                    ),
                ),
                (
                    'updated_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='MODEL_SUPPLIERWARNING::UPDATED_AT',
                    ),
                ),
                (
                    'author',
                    procu.soft_delete.models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='supplier_warnings',
                        to=settings.AUTH_USER_MODEL,
                        verbose_name='MODEL_SUPPLIERWARNING::AUTHOR',
                    ),
                ),
                (
                    'supplier',
                    procu.soft_delete.models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='warnings',
                        to='api.Supplier',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
                'base_manager_name': 'objects',
                'default_manager_name': 'with_deleted',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('with_deleted', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Unit',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'is_deleted',
                    models.BooleanField(default=False, editable=False),
                ),
                ('name', models.TextField(verbose_name='MODEL_UNIT::NAME')),
                (
                    'shortname',
                    models.TextField(verbose_name='MODEL_UNIT::SHORTNAME'),
                ),
            ],
            options={
                'ordering': ('pk',),
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('username', models.TextField()),
                (
                    'group',
                    procu.soft_delete.models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='auth.Group',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'default_permissions': (
                    'create',
                    'retrieve',
                    'update',
                    'delete',
                    'list',
                ),
            },
        ),
        migrations.AddField(
            model_name='supplier',
            name='tags',
            field=models.ManyToManyField(
                blank=True,
                related_name='suppliers',
                to='api.SupplierTag',
                verbose_name='MODEL_SUPPLIER::TAGS',
            ),
        ),
        migrations.AddField(
            model_name='quoteproduct',
            name='snapshot',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to='api.QuoteProductSnapshot',
            ),
        ),
        migrations.AddField(
            model_name='quote',
            name='request',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='quotes',
                to='api.Request',
            ),
        ),
        migrations.AddField(
            model_name='quote',
            name='supplier',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name='quotes',
                to='api.Supplier',
            ),
        ),
        migrations.AddField(
            model_name='oraclesubsystem',
            name='system',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='subsystems',
                to='api.OracleSystem',
                verbose_name='MODEL_ORACLESUBSYSTEM::SYSTEM',
            ),
        ),
        migrations.AddField(
            model_name='log',
            name='quote',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to='api.Quote',
            ),
        ),
        migrations.AddField(
            model_name='log',
            name='user',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddIndex(
            model_name='linkobject',
            index=models.Index(
                fields=['object_id'], name='api_linkobj_object__f34bf8_idx'
            ),
        ),
        migrations.AddField(
            model_name='link',
            name='author',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name='link',
            name='enquiry',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='links',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='link',
            name='object',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to='api.LinkObject'
            ),
        ),
        migrations.AddField(
            model_name='legalentity',
            name='oracle_legal_entity',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='legal_entity',
                to='api.OracleCompany',
                verbose_name='MODEL_LEGAL_ENTITY::ORACLE_LEGAL_ENTITY',
            ),
        ),
        migrations.AddField(
            model_name='invoiceproduct',
            name='address',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name='invoice_products',
                to='api.Address',
                verbose_name='MODEL_INVOICEPRODUCT::ADDRESS',
            ),
        ),
        migrations.AddField(
            model_name='invoiceproduct',
            name='currency',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to='api.Currency',
                verbose_name='MODEL_INVOICEPRODUCT::CURRENCY',
            ),
        ),
        migrations.AddField(
            model_name='invoiceproduct',
            name='invoice',
            field=procu.soft_delete.models.ForeignKey(
                editable=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='products',
                to='api.Invoice',
            ),
        ),
        migrations.AddField(
            model_name='invoiceproduct',
            name='unit',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to='api.Unit',
                verbose_name='MODEL_INVOICEPRODUCT::UNIT',
            ),
        ),
        migrations.AddField(
            model_name='invoice',
            name='enquiry',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name='invoices',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='invoice',
            name='legal_entity',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name='invoices',
                to='api.LegalEntity',
                verbose_name='MODEL_INVOICE::LEGAL_ENTITY',
            ),
        ),
        migrations.AddField(
            model_name='invoice',
            name='supplier',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name='invoices',
                to='api.Supplier',
            ),
        ),
        migrations.AddField(
            model_name='formdata',
            name='author',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name='enquirysaving',
            name='currency',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to='api.Currency',
            ),
        ),
        migrations.AddField(
            model_name='enquirysaving',
            name='enquiry',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='saving',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='enquiryproduct',
            name='enquiry',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='products',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='enquiryproduct',
            name='request',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='products',
                to='api.Request',
            ),
        ),
        migrations.AddField(
            model_name='enquirynote',
            name='enquiry',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='notes',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='enquirynote',
            name='user',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='enquiry_notes',
                to=settings.AUTH_USER_MODEL,
                verbose_name='MODEL_ENQUIRYNOTE::USER',
            ),
        ),
        migrations.AddField(
            model_name='enquirycomment',
            name='author',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name='enquirycomment',
            name='enquiry',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='comments',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='enquirycomment',
            name='invitees',
            field=models.ManyToManyField(
                blank=True,
                related_name='_enquirycomment_invitees_+',
                to=settings.AUTH_USER_MODEL,
                verbose_name='MODEL_ENQUIRY_COMMENT::INVITEES',
            ),
        ),
        migrations.AddField(
            model_name='enquirycategory',
            name='managers',
            field=models.ManyToManyField(
                blank=True,
                related_name='types',
                to=settings.AUTH_USER_MODEL,
                verbose_name='MODEL_ENQUIRY_TYPE::MANAGERS',
            ),
        ),
        migrations.AddField(
            model_name='enquiryaccess',
            name='enquiry',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='access',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='enquiryaccess',
            name='user',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
                verbose_name='MODEL_ENQUIRYACCESS::USER',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='address',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='enquiries',
                to='api.Address',
                verbose_name='MODEL_ENQUIRY::ADDRESS',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='author',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
                verbose_name='MODEL_ENQUIRY::AUTHOR',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='budget_line',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleBudgetLine',
                verbose_name='MODEL_ENQUIRY::BUDGET_LINE',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='category',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to='api.EnquiryCategory',
                verbose_name='MODEL_ENQUIRY::CATEGORY',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='cfo',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleCFO',
                verbose_name='MODEL_ENQUIRY::CFO',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='legal_entity',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to='api.LegalEntity',
                verbose_name='MODEL_ENQUIRY::LEGAL_ENTITY',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='manager',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
                verbose_name='MODEL_ENQUIRY::MANAGER',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='mvp',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleMVP',
                verbose_name='MODEL_ENQUIRY::MVP',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='program',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleProgram',
                verbose_name='MODEL_ENQUIRY::PROGRAM',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='project',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleProject',
                verbose_name='MODEL_ENQUIRY::PROJECT',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='service',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleService',
                verbose_name='MODEL_ENQUIRY::SERVICE',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='subsystem',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleSubSystem',
                verbose_name='MODEL_ENQUIRY::SUBSYSTEM',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='system',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleSystem',
                verbose_name='MODEL_ENQUIRY::SYSTEM',
            ),
        ),
        migrations.AddField(
            model_name='enquiry',
            name='task',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='api.OracleTask',
                verbose_name='MODEL_ENQUIRY::TASK',
            ),
        ),
        migrations.AddField(
            model_name='dashboardwidget',
            name='dashboard',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='widgets',
                to='api.Dashboard',
                verbose_name='DASHBOARDWIDGET::DASHBOARD',
            ),
        ),
        migrations.AddField(
            model_name='dashboard',
            name='author',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='dashboards',
                to=settings.AUTH_USER_MODEL,
                verbose_name='DASHBOARD::AUTHOR',
            ),
        ),
        migrations.AddField(
            model_name='currency',
            name='oracle_currency',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='procu_currency',
                to='api.OracleCurrency',
                verbose_name='MODEL_CURRENCY::ORACLE_CURRENCY',
            ),
        ),
        migrations.AddField(
            model_name='authtoken',
            name='user',
            field=procu.soft_delete.models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name='attachment',
            name='author',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='+',
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name='attachment',
            name='comment',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='attachments',
                to='api.QuoteComment',
            ),
        ),
        migrations.AddField(
            model_name='attachment',
            name='enquiry',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='attachments',
                to='api.Enquiry',
            ),
        ),
        migrations.AddField(
            model_name='attachment',
            name='enquiry_comment',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='attachments',
                to='api.EnquiryComment',
            ),
        ),
        migrations.AddField(
            model_name='attachment',
            name='request',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='attachments',
                to='api.Request',
            ),
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(
                blank=True,
                help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.',
                related_name='user_set',
                related_query_name='user',
                to='auth.Group',
                verbose_name='groups',
            ),
        ),
        migrations.AddField(
            model_name='user',
            name='supplier',
            field=procu.soft_delete.models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='agents',
                to='api.Supplier',
                verbose_name='MODEL_USER::SUPPLIER',
            ),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(
                blank=True,
                help_text='Specific permissions for this user.',
                related_name='user_set',
                related_query_name='user',
                to='auth.Permission',
                verbose_name='user permissions',
            ),
        ),
        migrations.AlterUniqueTogether(
            name='usergroup', unique_together={('username', 'group')}
        ),
        migrations.AlterUniqueTogether(
            name='enquirynote', unique_together={('enquiry', 'user')}
        ),
        migrations.AlterUniqueTogether(
            name='enquiryaccess', unique_together={('enquiry', 'user')}
        ),
    ]
