# Generated by Django 2.0.6 on 2018-08-08 15:00

from django.db import migrations


SQL_CREATE = """
-- -----------------------------------------------------------------------------
-- Via assignee

CREATE OR REPLACE FUNCTION add_access_via_assignee() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP = 'UPDATE' AND OLD.manager_id = NEW.manager_id THEN
      RETURN NULL;
    END IF;

    IF TG_OP = 'UPDATE' THEN
      UPDATE api_enquiryaccess SET
        sources = array_remove(sources, 400)
      WHERE
        enquiry_id=NEW.id AND user_id=OLD.manager_id;

      DELETE FROM api_enquiryaccess
      WHERE
        enquiry_id=OLD.id
        AND user_id=OLD.manager_id
        AND sources = '{}';
    END IF;

    IF NEW.manager_id IS NULL THEN
      RETURN NULL;
    END IF;

    INSERT INTO api_enquiryaccess as a (enquiry_id, user_id, sources, is_subscribed)
    VALUES (NEW.id, NEW.manager_id, '{400}'::int[], 't')
    ON CONFLICT (user_id, enquiry_id) DO UPDATE
    SET sources = ARRAY(SELECT DISTINCT UNNEST(a.sources || 400) ORDER BY 1), is_subscribed='t';

    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trigger_add_access_via_assignee ON api_enquiry;
CREATE TRIGGER trigger_add_access_via_assignee
AFTER INSERT OR UPDATE ON api_enquiry
FOR EACH ROW
EXECUTE PROCEDURE add_access_via_assignee();

-- -----------------------------------------------------------------------------
-- Via author

CREATE OR REPLACE FUNCTION add_access_via_author() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP = 'UPDATE' AND OLD.author_id = NEW.author_id THEN
      RETURN NULL;
    END IF;

    IF TG_OP = 'UPDATE' THEN
      UPDATE api_enquiryaccess SET
        sources = array_remove(sources, 300)
      WHERE
        enquiry_id=NEW.id AND user_id=OLD.author_id;

      DELETE FROM api_enquiryaccess
      WHERE
        enquiry_id=OLD.id
        AND user_id=OLD.author_id
        AND sources = '{}';
    END IF;

    IF NEW.author_id IS NULL THEN
      RETURN NULL;
    END IF;

    INSERT INTO api_enquiryaccess as a (enquiry_id, user_id, sources, is_subscribed)
    VALUES (NEW.id, NEW.author_id, '{300}'::int[], 't')
    ON CONFLICT (user_id, enquiry_id) DO UPDATE
    SET sources = ARRAY(SELECT DISTINCT UNNEST(a.sources || 300) ORDER BY 1), is_subscribed='t';

    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trigger_add_access_via_author ON api_enquiry;
CREATE TRIGGER trigger_add_access_via_author
AFTER INSERT OR UPDATE ON api_enquiry
FOR EACH ROW
EXECUTE PROCEDURE add_access_via_author();

-- -----------------------------------------------------------------------------
-- Via enquiry type

CREATE OR REPLACE FUNCTION add_access_via_enquiry_type() RETURNS TRIGGER AS $$
  BEGIN
    INSERT INTO api_enquiryaccess as a (enquiry_id, user_id, sources, is_subscribed)
    SELECT id, NEW.user_id, '{100}'::int[], 'f' FROM api_enquiry WHERE category_id=NEW.enquirycategory_id
    ON CONFLICT (user_id, enquiry_id) DO UPDATE
    SET sources = ARRAY(SELECT DISTINCT UNNEST(a.sources || 100) ORDER BY 1);
    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trigger_add_access_via_enquiry_type ON api_enquirycategory_managers;
CREATE TRIGGER trigger_add_access_via_enquiry_type
AFTER INSERT ON api_enquirycategory_managers
FOR EACH ROW
EXECUTE PROCEDURE add_access_via_enquiry_type();

-- -----

CREATE OR REPLACE FUNCTION remove_access_via_enquiry_type() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE api_enquiryaccess a SET
      sources = array_remove(sources, 100)
    FROM api_enquiry e
    WHERE
      e.id = a.enquiry_id
      AND e.category_id=OLD.enquirycategory_id
      AND a.user_id=OLD.user_id;

    DELETE
      FROM api_enquiryaccess a
      USING api_enquiry e
    WHERE
      e.id = a.enquiry_id
      AND e.category_id=OLD.enquirycategory_id
      AND a.user_id=OLD.user_id
      AND sources = '{}';
    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;


DROP TRIGGER IF EXISTS trigger_remove_access_via_enquiry_type ON api_enquirycategory_managers;
CREATE TRIGGER trigger_remove_access_via_enquiry_type
AFTER DELETE ON api_enquirycategory_managers
FOR EACH ROW
EXECUTE PROCEDURE remove_access_via_enquiry_type();

-- -----

CREATE OR REPLACE FUNCTION change_access_via_enquiry_type() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP = 'UPDATE' AND OLD.category_id = NEW.category_id THEN
      RETURN NULL;
    END IF;

    IF TG_OP = 'UPDATE' THEN

      UPDATE api_enquiryaccess a SET
        sources = array_remove(sources, 100)
      FROM api_enquirycategory_managers m
      WHERE
        m.enquirycategory_id = OLD.category_id
        AND a.enquiry_id=NEW.id
        AND a.user_id=m.user_id;

      DELETE
        FROM api_enquiryaccess a
        USING api_enquirycategory_managers m
      WHERE
        m.enquirycategory_id  = OLD.category_id
        AND a.enquiry_id=NEW.id
        AND a.user_id=m.user_id
        AND sources = '{}';
    END IF;

    IF NEW.category_id IS NULL THEN
      RETURN NULL;
    END IF;

    INSERT INTO api_enquiryaccess as a (enquiry_id, user_id, sources, is_subscribed)
    SELECT NEW.id, user_id, '{100}'::int[], 'f' FROM api_enquirycategory_managers WHERE enquirycategory_id=NEW.category_id
    ON CONFLICT (user_id, enquiry_id) DO UPDATE
    SET sources = ARRAY(SELECT DISTINCT UNNEST(a.sources || 100) ORDER BY 1);

    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trigger_change_access_via_enquiry_type ON api_enquiry;
CREATE TRIGGER trigger_change_access_via_enquiry_type
AFTER INSERT OR UPDATE ON api_enquiry
FOR EACH ROW
EXECUTE PROCEDURE change_access_via_enquiry_type();

-- -----------------------------------------------------------------------------
-- Via CFO

CREATE OR REPLACE FUNCTION add_access_via_cfo() RETURNS TRIGGER AS $$
  BEGIN
    INSERT INTO api_enquiryaccess as a (enquiry_id, user_id, sources, is_subscribed)
    SELECT id, NEW.user_id, '{200}'::int[], 'f' FROM api_enquiry WHERE cfo_id=NEW.oraclecfo_id
    ON CONFLICT (user_id, enquiry_id) DO UPDATE
    SET sources = ARRAY(SELECT DISTINCT UNNEST(a.sources || 200) ORDER BY 1);
    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trigger_add_access_via_cfo ON api_oraclecfo_users;
CREATE TRIGGER trigger_add_access_via_cfo
AFTER INSERT ON api_oraclecfo_users
FOR EACH ROW
EXECUTE PROCEDURE add_access_via_cfo();

-- -----

CREATE OR REPLACE FUNCTION remove_access_via_cfo() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE api_enquiryaccess a SET
      sources = array_remove(sources, 200)
    FROM api_enquiry e
    WHERE
      e.id = a.enquiry_id
      AND e.cfo_id=OLD.oraclecfo_id
      AND a.user_id=OLD.user_id;

    DELETE
      FROM api_enquiryaccess a
      USING api_enquiry e
    WHERE
      e.id = a.enquiry_id
      AND e.cfo_id=OLD.oraclecfo_id
      AND a.user_id=OLD.user_id
      AND sources = '{}';
    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;


DROP TRIGGER IF EXISTS trigger_remove_access_via_cfo ON api_oraclecfo_users;
CREATE TRIGGER trigger_remove_access_via_cfo
AFTER DELETE ON api_oraclecfo_users
FOR EACH ROW
EXECUTE PROCEDURE remove_access_via_cfo();

-- -----

CREATE OR REPLACE FUNCTION change_access_via_cfo() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP = 'UPDATE' AND OLD.cfo_id = NEW.cfo_id THEN
      RETURN NULL;
    END IF;

    IF TG_OP = 'UPDATE' THEN

      UPDATE api_enquiryaccess a SET
        sources = array_remove(sources, 200)
      FROM api_oraclecfo_users m
      WHERE
        m.oraclecfo_id = OLD.cfo_id
        AND a.enquiry_id=NEW.id
        AND a.user_id=m.user_id;

      DELETE
        FROM api_enquiryaccess a
        USING api_oraclecfo_users m
      WHERE
        m.oraclecfo_id  = OLD.cfo_id
        AND a.enquiry_id=NEW.id
        AND a.user_id=m.user_id
        AND sources = '{}';
    END IF;

    IF NEW.cfo_id IS NULL THEN
      RETURN NULL;
    END IF;

    INSERT INTO api_enquiryaccess as a (enquiry_id, user_id, sources, is_subscribed)
    SELECT NEW.id, user_id, '{200}'::int[], 'f' FROM api_oraclecfo_users WHERE oraclecfo_id=NEW.cfo_id
    ON CONFLICT (user_id, enquiry_id) DO UPDATE
    SET sources = ARRAY(SELECT DISTINCT UNNEST(a.sources || 200) ORDER BY 1);

    RETURN NULL;
  END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trigger_change_access_via_cfo ON api_enquiry;
CREATE TRIGGER trigger_change_access_via_cfo
AFTER INSERT OR UPDATE ON api_enquiry
FOR EACH ROW
EXECUTE PROCEDURE change_access_via_cfo();
"""


SQL_DROP = """
DROP FUNCTION IF EXISTS add_access_via_assignee() CASCADE;
DROP FUNCTION IF EXISTS add_access_via_author() CASCADE;
DROP FUNCTION IF EXISTS add_access_via_enquiry_type() CASCADE;
DROP FUNCTION IF EXISTS remove_access_via_enquiry_type() CASCADE;
DROP FUNCTION IF EXISTS change_access_via_enquiry_type() CASCADE;
"""


class Migration(migrations.Migration):

    dependencies = [('api', '0001_initial')]

    operations = [
        migrations.RunSQL(sql=SQL_CREATE, reverse_sql=SQL_DROP, elidable=False)
    ]
