# Generated by Django 2.0.6 on 2018-08-08 15:38

from django.db import migrations


SQL_CREATE = """
CREATE OR REPLACE FUNCTION sync_enquiry() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE api_enquiry e
    SET
        status = c.new_status,
        reason = c.new_reason
    FROM (
        SELECT
            COALESCE(MIN(status), 150) as new_status,
            COALESCE(MIN(reason), 1000) as new_reason
        FROM api_request
        WHERE enquiry_id = NEW.enquiry_id
        GROUP BY enquiry_id
    ) c
    WHERE e.id = NEW.enquiry_id;
    RETURN NEW;
  END;
$$ LANGUAGE plpgsql;


DROP TRIGGER IF EXISTS trigger_update_sync_enquiry ON api_request;
CREATE TRIGGER trigger_update_sync_enquiry
AFTER UPDATE ON api_request
FOR EACH ROW
WHEN (
  (OLD.status, OLD.reason)
    IS DISTINCT FROM
  (NEW.status, NEW.reason)
)
EXECUTE PROCEDURE sync_enquiry();


DROP TRIGGER IF EXISTS trigger_insert_sync_enquiry ON api_request;
CREATE TRIGGER trigger_insert_sync_enquiry
AFTER INSERT ON api_request
FOR EACH ROW
EXECUTE PROCEDURE sync_enquiry();
"""


SQL_DROP = """
DROP FUNCTION IF EXISTS sync_request() CASCADE;
"""


class Migration(migrations.Migration):

    dependencies = [('api', '0002_sql_access')]

    operations = [
        migrations.RunSQL(sql=SQL_CREATE, reverse_sql=SQL_DROP, elidable=False)
    ]
