# Generated by Django 2.0.6 on 2018-08-08 15:52

from django.db import migrations


SQL_CREATE = """
CREATE OR REPLACE FUNCTION set_request_key() RETURNS TRIGGER AS $$
    BEGIN
        NEW."key" := CONCAT('YP', NEW."enquiry_id"::text);
        RETURN NEW;
    END;
$$ LANGUAGE plpgsql;


DROP TRIGGER IF EXISTS trigger_set_request_key ON api_request;
CREATE TRIGGER trigger_set_request_key
BEFORE INSERT ON api_request
FOR EACH ROW
EXECUTE PROCEDURE set_request_key();
"""


SQL_DROP = """
DROP FUNCTION IF EXISTS set_request_key() CASCADE;
"""


class Migration(migrations.Migration):

    dependencies = [('api', '0005_sql_set_product_parent')]

    operations = [
        migrations.RunSQL(sql=SQL_CREATE, reverse_sql=SQL_DROP, elidable=False)
    ]
