# Generated by Django 2.0.6 on 2018-08-08 15:53

from django.db import migrations


SQL_CREATE = """
CREATE OR REPLACE FUNCTION sync_request() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE api_request r
    SET
        status = c.new_status,
        reason = c.new_reason,
        deadline_at = c.new_deadline
    FROM (
        SELECT
            COALESCE(MIN(status), 150) as new_status,
            COALESCE(MIN(reason), 1000) as new_reason,
            MAX(deadline_at) as new_deadline
        FROM api_quote
        WHERE
            request_id=NEW.request_id
            AND is_deleted='f'
    ) c
    WHERE r.id=NEW.request_id;

    RETURN NEW;
  END;
$$ LANGUAGE plpgsql;


DROP TRIGGER IF EXISTS trigger_update_sync_request ON api_quote;
CREATE TRIGGER trigger_update_sync_request
AFTER UPDATE ON api_quote
FOR EACH ROW
WHEN (
  (OLD.status, OLD.reason, OLD.deadline_at)
    IS DISTINCT FROM
  (NEW.status, NEW.reason, NEW.deadline_at)
)
EXECUTE PROCEDURE sync_request();


DROP TRIGGER IF EXISTS trigger_insert_sync_request ON api_quote;
CREATE TRIGGER trigger_insert_sync_request
AFTER INSERT ON api_quote
FOR EACH ROW
EXECUTE PROCEDURE sync_request();
"""


SQL_DROP = """
DROP FUNCTION IF EXISTS sync_request() CASCADE;
"""


class Migration(migrations.Migration):

    dependencies = [('api', '0006_sql_request_key')]

    operations = [
        migrations.RunSQL(sql=SQL_CREATE, reverse_sql=SQL_DROP, elidable=False)
    ]
