# Generated by Django 2.0.6 on 2018-08-08 15:55

from django.db import migrations


SQL_CREATE = """
CREATE OR REPLACE FUNCTION set_enquiry_key() RETURNS TRIGGER AS $$
    BEGIN
        NEW."key" := CONCAT('YP', NEW."id"::text);
        RETURN NEW;
    END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trigger_create_enquiry ON api_enquiry;
CREATE TRIGGER trigger_create_enquiry
BEFORE INSERT ON api_enquiry
FOR EACH ROW
EXECUTE PROCEDURE set_enquiry_key();
"""


SQL_DROP = """
DROP FUNCTION IF EXISTS set_enquiry_key() CASCADE;
"""


class Migration(migrations.Migration):

    dependencies = [('api', '0007_sql_request_status')]

    operations = [
        migrations.RunSQL(sql=SQL_CREATE, reverse_sql=SQL_DROP, elidable=False)
    ]
