# coding: utf-8

from django.conf import settings
from django.utils.translation import gettext_lazy as _
from rest_framework.exceptions import ValidationError

from procu.api import models
from procu.api.utils import json_dumps
from procu.rest import serializers


class FormData(serializers.ModelSerializer):

    data = serializers.JSONField()

    class Meta:
        model = models.FormData
        fields = ('key', 'data')
        read_only_fields = ('key',)

    @staticmethod
    def validate_data(data):

        json_string = json_dumps(data)

        if len(json_string) > settings.FORM_STORAGE_MAX_SIZE:
            raise ValidationError(_('FORM_STORAGE::SIZE_EXCEEDS'))

        return data


class WFPreview(serializers.Serializer):

    message = serializers.CharField(allow_blank=True)
