# coding: utf-8

from django.db.transaction import non_atomic_requests
from django.urls import re_path

from .views import *

urlpatterns = [
    re_path(r'^/deadline/(?P<days>[0-9]+)/?$', DeadlineView.as_view()),
    re_path(r'^/phone/?$', PhoneView.as_view()),
    re_path(r'^/sections/?$', SectionsView.as_view()),
    re_path(r'^/forms/?$', CreateFormsView.as_view()),
    re_path(r'^/storage/?$', FormDataCreateView.as_view()),
    re_path(
        r'^/storage/(?P<key>[0-9a-f\-]+)?$', FormDataRetrieveView.as_view()
    ),
    re_path(r'^/wf/?$', non_atomic_requests(WFPreview.as_view())),
    re_path(
        r'^/reset_static_version$',
        non_atomic_requests(ResetStaticCache.as_view()),
    ),
]
