# coding: utf-8

from rest_framework.filters import OrderingFilter

from procu.api import models
from procu.rest import generics
from procu.rest.filters import IncludeFilter, SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import NonManagerReadOnly
from . import serializers


class CFOList(generics.ListAPIView):

    queryset = models.OracleCFO.objects.prefetch_related('users').filter(
        is_deleted=False
    )

    serializer_class = serializers.ListRetrieve
    pagination_class = PageNumberPagination
    permission_classes = (NonManagerReadOnly,)

    filter_backends = (IncludeFilter, SearchFilter, OrderingFilter)

    search_fields = ('key', 'name')
    ordering_fields = ('key', 'name')
    ordering = ('key',)


class CFORetrieve(generics.RetrieveAPIView):

    queryset = models.OracleCFO.objects.prefetch_related('users').all()

    serializer_class = serializers.ListRetrieve
    permission_classes = (NonManagerReadOnly,)
    lookup_url_kwarg = 'cfo_id'
