# coding: utf-8

from rest_framework.filters import OrderingFilter

from procu.api import models
from procu.rest import generics
from procu.rest.filters import IncludeFilter, SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import NonManagerReadOnly
from . import serializers


class ProductLineList(generics.ListAPIView):
    queryset = models.OracleProductLine.objects.all()
    serializer_class = serializers.ListRetrive
    pagination_class = PageNumberPagination
    permission_classes = (NonManagerReadOnly,)
    filter_backends = (IncludeFilter, SearchFilter, OrderingFilter)
    search_fields = ('key', 'name')

    ordering_fields = ('key', 'name')
    ordering = ('key',)


class ProductLineRetrieve(generics.RetrieveAPIView):
    queryset = models.OracleProductLine.objects.all()
    serializer_class = serializers.ListRetrive
    permission_classes = (NonManagerReadOnly,)
    lookup_url_kwarg = 'product_line_id'
