# coding: utf-8

from rest_framework.filters import OrderingFilter

from procu.api import models
from procu.rest import generics
from procu.rest.filters import IncludeFilter, SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import NonManagerReadOnly
from . import serializers


class PurchaseGroupList(generics.ListAPIView):
    queryset = models.OraclePurchaseGroup.objects.all()
    serializer_class = serializers.PurchaseGroup
    pagination_class = PageNumberPagination
    permission_classes = (NonManagerReadOnly,)
    filter_backends = (IncludeFilter, SearchFilter, OrderingFilter)
    search_fields = ('key', 'name')

    ordering_fields = ('key', 'name')
    ordering = ('name',)


class PurchaseGroupRetrieve(generics.RetrieveAPIView):
    queryset = models.OraclePurchaseGroup.objects.all()
    serializer_class = serializers.PurchaseGroup
    permission_classes = (NonManagerReadOnly,)
    lookup_url_kwarg = 'group_id'
