# coding: utf-8

from django_filters.rest_framework import DjangoFilterBackend
from rest_framework.filters import OrderingFilter

from procu.api import models
from procu.rest import generics
from procu.rest.filters import IncludeFilter, SearchFilter
from procu.rest.pagination import PageNumberPagination
from procu.rest.permissions import NonManagerReadOnly
from . import serializers


class TaskList(generics.ListAPIView):
    queryset = models.OracleTask.objects.select_related('project').filter(
        is_deleted=False
    )
    serializer_class = serializers.Task
    pagination_class = PageNumberPagination
    permission_classes = (NonManagerReadOnly,)
    filter_backends = (
        IncludeFilter,
        SearchFilter,
        OrderingFilter,
        DjangoFilterBackend,
    )
    filter_fields = ('project', 'project__program')
    search_fields = ('key', 'name')
    ordering_fields = ('key', 'name')
    ordering = ('key',)


class TaskRetrieve(generics.RetrieveAPIView):
    queryset = models.OracleTask.objects.all()
    serializer_class = serializers.Task
    permission_classes = (NonManagerReadOnly,)
    lookup_url_kwarg = 'task_id'
