# coding: utf-8

from django.conf import settings
from django.core.mail import EmailMultiAlternatives
from html2text import html2text
from premailer import Premailer


class EmailMessage(EmailMultiAlternatives):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        html = Premailer(self.body, **settings.PREMAILER_CONFIG).transform()

        if settings.EMAIL_MOCK:

            notice = """
            <p style="margin:0 0 1em 0;">
            Sent from testing enviroment. Original recipients:<br/>
            To: {}
            """.format(
                ', '.join(self.to)
            )

            if self.cc:
                notice += '<br>\nCc: {}'.format(', '.join(self.cc))
            if self.bcc:
                notice += '<br>\nBcc: {}'.format(', '.join(self.bcc))

            notice += '</p>'

            if '<!-- footer -->' in html:
                html = html.replace('<!-- footer -->', notice)
            else:
                html += notice

            self.to = [settings.EMAIL_MOCK_COLLECTOR]
            self.cc = []
            self.bcc = []

        self.body = html2text(self.body)
        self.attach_alternative(html, 'text/html')
