# coding: utf-8

from django.conf import settings

from procu.api import models


class Nothing(object):
    pass


def to_dict(instance, fields):

    data = {}

    for field in fields:
        value = getattr(instance, field, Nothing)
        if value is not Nothing:
            data[field] = value

    return data


def get_reply_token(quote_id):
    reply_token, created = models.QuoteReply.objects.get_or_create(
        quote_id=quote_id
    )
    return reply_token.token


def get_robot_email(name, action=None, token=None):

    addr = settings.EMAIL_ROBOT
    assert addr.count('@')

    if not (action is token is None):
        prefix = f'+{action}-{token}@'
        addr = addr.replace('@', prefix)

    return f'{name} <{addr}>'


def get_addrs(name, *, email=None, quote_id=None):

    if email is None:
        from_email = get_robot_email(name)
    else:
        from_email = f'{name} <{email}>'

    kwargs = {'from_email': from_email, 'cc': []}

    if quote_id is not None:
        token = get_reply_token(quote_id)
        kwargs['reply_to'] = [get_robot_email(name, 'quote', token)]

    return kwargs
