# coding: utf-8

from rest_framework.permissions import BasePermission

from ..permissions import ValidQuotePermission


class CreatePermission(BasePermission):
    def has_permission(self, request, view):

        if request.method == 'POST':
            return ValidQuotePermission().has_permission(request, view)

        return True


class UpdateDestroyPermission(BasePermission):
    def has_permission(self, request, view):

        if request.method in ('PATCH', 'DELETE'):
            instance = view.object
            return instance.author_id == request.user.id

        return True
