# coding: utf-8
import mimetypes

from django.core.files import File
from django.http import HttpResponse

from procu.api.common import rfx
from procu.rest import generics
from procu.rest.permissions import ExternalOnly
from ..permissions import ValidQuotePermission

mimetypes.init()


class ExportRetrieve(generics.GenericAPIView):
    permission_classes = (ExternalOnly, ValidQuotePermission)

    @staticmethod
    def get(request, quote_id):

        filename, output = rfx.export(int(quote_id))

        mimetype = mimetypes.types_map['.xlsx']

        response = HttpResponse(File(output), content_type=mimetype)
        response['Content-Disposition'] = f'attachment; filename="{filename}"'

        return response
