# coding: utf-8

from procu import jsonschema as js
from procu.api import enums
from procu.rest import serializers


class SchemaMixin:
    @staticmethod
    def get_schema(*args, **kwargs):
        return js.Object(('key', js.String()), ('name', js.String()))


class StatusField(SchemaMixin, serializers.ReadOnlyField):
    def to_representation(self, value):
        return {'key': enums.QS.keys[value], 'name': enums.QS.i18n[value]}


class ReasonField(SchemaMixin, serializers.ReadOnlyField):
    def to_representation(self, value):
        return {'key': enums.QR.keys[value], 'name': enums.QR.i18n[value]}
