# coding: utf-8

from rest_framework.filters import OrderingFilter


class RequestOrderingFilter(OrderingFilter):
    def filter_queryset(self, request, queryset, view):
        ordering = list(self.get_ordering(request, queryset, view))

        if ordering:
            if '-updated_at' not in ordering:
                ordering.extend(('-updated_at', 'id'))

            final_ordering = []

            for field in ordering:
                final_ordering.append(field)

            return queryset.order_by(*final_ordering)

        return queryset
