# coding: utf-8

from django.utils.translation import gettext_lazy as _

from procu.api import models
from procu.api.utils.staff import get_phone
from procu.rest import serializers
from .fields import (
    AddressBrief,
    AddressFull,
    InfoFields,
    LegalEntityBrief,
    LegalEntityFull,
)


class InfoInitial(serializers.ModelSerializer):

    attachments = InfoFields.attachments()

    comment = InfoFields.comment()
    address = InfoFields.address(AddressBrief)
    legal_entity = InfoFields.legal_entity(LegalEntityBrief)

    assignee = serializers.SerializerMethodField(
        label=_('ENQUIRY_EXT_INFO::ASSIGNEE')
    )

    class Meta:
        model = models.Request
        fields = (
            'comment',
            'attachments',
            'address',
            'legal_entity',
            'assignee',
        )

    @staticmethod
    def get_assignee(instance):

        if not instance.show_assignee:
            return None

        assignee = instance.enquiry.manager

        if not assignee:
            return None

        data = {
            'name': assignee.full_name,
            'email': assignee.email,
            'phone': None,
        }

        try:
            data['phone'] = get_phone(assignee.username)
        except ValueError:
            pass

        return data


class InfoCheckout(InfoInitial):

    legal_entity = InfoFields.legal_entity(LegalEntityFull)


class InfoShipped(InfoInitial):

    address = InfoFields.address(AddressFull)
    legal_entity = InfoFields.legal_entity(LegalEntityFull)
