# coding: utf-8
from procu.api import models
from procu.api.enums import QR, QS
from procu.rest import generics, permissions
from . import serializers
from ..permissions import ValidQuotePermission


class InfoRetrieve(generics.RetrieveAPIView):
    serializer_class = serializers.InfoInitial
    permission_classes = (permissions.ExternalOnly, ValidQuotePermission)
    lookup_url_kwarg = 'quote_id'
    lookup_field = 'quotes'

    def get_serializer_class(self):

        status, reason = (
            models.Quote.objects.permitted(self.request.user)
            .values_list('status', 'reason')
            .get(id=self.kwargs['quote_id'])
        )

        if status < QS.CHECKOUT or (
            status == QS.CLOSED and reason != QR.DELIVERED
        ):
            return serializers.InfoInitial

        elif status == QS.CHECKOUT:
            return serializers.InfoCheckout

        elif status == QS.SHIPPED or (
            status == QS.CLOSED and reason == QR.DELIVERED
        ):
            return serializers.InfoShipped

    def get_queryset(self):
        return (
            models.Request.objects.permitted(self.request.user)
            .select_related('address', 'legal_entity')
            .prefetch_related('attachments')
        )
