# coding: utf-8

from django.db.models import Prefetch

from procu.api import models
from procu.rest import generics, permissions
from .serializers import EnquiryProductSerializer
from ..permissions import ValidQuotePermission


class QuoteSummaryView(generics.ListAPIView):
    permission_classes = (permissions.ExternalOnly, ValidQuotePermission)
    serializer_class = EnquiryProductSerializer

    def list(self, request, *args, **kwargs):
        objs = list(self.get_queryset())
        serializer = self.get_serializer(objs, many=True)
        return self.get_paginated_response({'products': serializer.data})

    def get_queryset(self):
        quote_id = self.kwargs['quote_id']

        qp_qs = (
            models.QuoteProduct.objects.filter(quote_id=quote_id)
            .select_related('currency')
            .order_by('is_replacement', 'pk')
        )

        offers_qs = qp_qs.filter(is_replacement=False)
        replacements_qs = qp_qs.filter(is_replacement=True)

        return models.EnquiryProduct.objects.filter(
            request__quotes=quote_id
        ).prefetch_related(
            Prefetch('quote_products', offers_qs, 'offers'),
            Prefetch('quote_products', replacements_qs, 'replacements'),
        )
