# coding: utf-8

from django.utils.timezone import now
from rest_framework.permissions import BasePermission

from procu.api import enums, models


class UpdateQuotePermission(BasePermission):
    def has_object_permission(self, request, view, obj):
        if request.method == 'PATCH':
            return obj.status < enums.QS.CHECKOUT and obj.deadline_at > now()

        return True


class ValidQuotePermission(BasePermission):
    def has_permission(self, request, view):
        return (
            models.Quote.objects.permitted(request.user)
            .filter(id=view.kwargs['quote_id'])
            .exists()
        )
