# coding: utf-8
from procu.api import enums, models
from procu.api.common.fields import PaymentTermsField
from procu.rest import serializers
from .fields import ReasonField, StatusField


class RequestSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.Enquiry
        fields = ('key', 'subject', 'no_replacement')


class List(serializers.ModelSerializer):

    status = StatusField()
    reason = ReasonField()
    request = RequestSerializer()

    class Meta:
        model = models.Quote
        fields = (
            'id',
            'request',
            'deadline_at',
            'updated_at',
            'status',
            'reason',
            'has_offer',
            'has_won',
        )


class Update(serializers.ModelSerializer):
    terms = PaymentTermsField()

    class Meta:
        model = models.Quote
        fields = ('terms',)


class Retrieve(serializers.ModelSerializer):

    request = RequestSerializer()
    supplier = serializers.PrimaryKeyRelatedField(read_only=True)

    status = StatusField()
    reason = ReasonField()
    hide_products = serializers.SerializerMethodField()
    invoices = serializers.SerializerMethodField()
    terms = PaymentTermsField()

    class Meta:
        model = models.Quote
        fields = (
            'id',
            'request',
            'supplier',
            'deadline_at',
            'created_at',
            'updated_at',
            'delivery_at',
            'terms',
            'status',
            'reason',
            'has_offer',
            'has_won',
            'hide_products',
            'invoices',
        )

    @staticmethod
    def get_hide_products(instance):
        return instance.status >= enums.ES.CHECKOUT

    @staticmethod
    def get_invoices(instance):
        return []

        # return (
        #     models.Invoice.objects.filter(
        #         enquiry_id=instance.request.enquiry_id,
        #         supplier_id=instance.supplier_id,
        #     )
        #     .values('id', 'created_at')
        #     .order_by('-created_at')
        # )
