# coding: utf-8

from django.urls import include, path, re_path

from .views import *


def _include(_path):
    return include('procu.api.request.%s' % _path)


urlpatterns = [
    path(
        '/<int:quote_id>',
        include(
            [
                path('/info', _include('info.urls')),
                path('/offer', _include('offer.urls')),
                path('/export', _include('export.urls')),
                path('/roadmap', _include('roadmap.urls')),
                path('/comments', _include('comment.urls')),
                path('/products', _include('product.urls')),
                re_path(r'^/?$', RequestRetrieveUpdate.as_view()),
            ]
        ),
    ),
    re_path(r'^/?$', RequestList.as_view()),
]
